<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/firestore/admin/v1/database.proto

namespace Google\Cloud\Firestore\Admin\V1\Database;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The CMEK (Customer Managed Encryption Key) configuration for a Firestore
 * database. If not present, the database is secured by the default Google
 * encryption key.
 *
 * Generated from protobuf message <code>google.firestore.admin.v1.Database.CmekConfig</code>
 */
class CmekConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Only keys in the same location as this database are allowed to
     * be used for encryption.
     * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
     * multi-region us. For Firestore's eur3 multi-region, this corresponds to
     * Cloud KMS multi-region europe. See
     * https://cloud.google.com/kms/docs/locations.
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *
     * Generated from protobuf field <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $kms_key_name = '';
    /**
     * Output only. Currently in-use [KMS key
     * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
     * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
     * there can be multiple in-use key versions.
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
     *
     * Generated from protobuf field <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $active_key_version;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $kms_key_name
     *           Required. Only keys in the same location as this database are allowed to
     *           be used for encryption.
     *           For Firestore's nam5 multi-region, this corresponds to Cloud KMS
     *           multi-region us. For Firestore's eur3 multi-region, this corresponds to
     *           Cloud KMS multi-region europe. See
     *           https://cloud.google.com/kms/docs/locations.
     *           The expected format is
     *           `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $active_key_version
     *           Output only. Currently in-use [KMS key
     *           versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
     *           During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
     *           there can be multiple in-use key versions.
     *           The expected format is
     *           `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Firestore\Admin\V1\Database::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Only keys in the same location as this database are allowed to
     * be used for encryption.
     * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
     * multi-region us. For Firestore's eur3 multi-region, this corresponds to
     * Cloud KMS multi-region europe. See
     * https://cloud.google.com/kms/docs/locations.
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *
     * Generated from protobuf field <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getKmsKeyName()
    {
        return $this->kms_key_name;
    }

    /**
     * Required. Only keys in the same location as this database are allowed to
     * be used for encryption.
     * For Firestore's nam5 multi-region, this corresponds to Cloud KMS
     * multi-region us. For Firestore's eur3 multi-region, this corresponds to
     * Cloud KMS multi-region europe. See
     * https://cloud.google.com/kms/docs/locations.
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     *
     * Generated from protobuf field <code>string kms_key_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKeyName($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key_name = $var;

        return $this;
    }

    /**
     * Output only. Currently in-use [KMS key
     * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
     * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
     * there can be multiple in-use key versions.
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
     *
     * Generated from protobuf field <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getActiveKeyVersion()
    {
        return $this->active_key_version;
    }

    /**
     * Output only. Currently in-use [KMS key
     * versions](https://cloud.google.com/kms/docs/resource-hierarchy#key_versions).
     * During [key rotation](https://cloud.google.com/kms/docs/key-rotation),
     * there can be multiple in-use key versions.
     * The expected format is
     * `projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{key_version}`.
     *
     * Generated from protobuf field <code>repeated string active_key_version = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setActiveKeyVersion($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->active_key_version = $arr;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CmekConfig::class, \Google\Cloud\Firestore\Admin\V1\Database_CmekConfig::class);

