<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/firestore/admin/v1/schedule.proto

namespace Google\Cloud\Firestore\Admin\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A backup schedule for a Cloud Firestore Database.
 * This resource is owned by the database it is backing up, and is deleted along
 * with the database. The actual backups are not though.
 *
 * Generated from protobuf message <code>google.firestore.admin.v1.BackupSchedule</code>
 */
class BackupSchedule extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The unique backup schedule identifier across all locations and
     * databases for the given project.
     * This will be auto-assigned.
     * Format is
     * `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Output only. The timestamp at which this backup schedule was created and
     * effective since.
     * No backups will be created for this schedule before this time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The timestamp at which this backup schedule was most recently
     * updated. When a backup schedule is first created, this is the same as
     * create_time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * At what relative time in the future, compared to its creation time,
     * the backup should be deleted, e.g. keep backups for 7 days.
     * The maximum supported retention period is 14 weeks.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration retention = 6;</code>
     */
    private $retention = null;
    protected $recurrence;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The unique backup schedule identifier across all locations and
     *           databases for the given project.
     *           This will be auto-assigned.
     *           Format is
     *           `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp at which this backup schedule was created and
     *           effective since.
     *           No backups will be created for this schedule before this time.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp at which this backup schedule was most recently
     *           updated. When a backup schedule is first created, this is the same as
     *           create_time.
     *     @type \Google\Protobuf\Duration $retention
     *           At what relative time in the future, compared to its creation time,
     *           the backup should be deleted, e.g. keep backups for 7 days.
     *           The maximum supported retention period is 14 weeks.
     *     @type \Google\Cloud\Firestore\Admin\V1\DailyRecurrence $daily_recurrence
     *           For a schedule that runs daily.
     *     @type \Google\Cloud\Firestore\Admin\V1\WeeklyRecurrence $weekly_recurrence
     *           For a schedule that runs weekly on a specific day.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Firestore\Admin\V1\Schedule::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The unique backup schedule identifier across all locations and
     * databases for the given project.
     * This will be auto-assigned.
     * Format is
     * `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The unique backup schedule identifier across all locations and
     * databases for the given project.
     * This will be auto-assigned.
     * Format is
     * `projects/{project}/databases/{database}/backupSchedules/{backup_schedule}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The timestamp at which this backup schedule was created and
     * effective since.
     * No backups will be created for this schedule before this time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp at which this backup schedule was created and
     * effective since.
     * No backups will be created for this schedule before this time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp at which this backup schedule was most recently
     * updated. When a backup schedule is first created, this is the same as
     * create_time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp at which this backup schedule was most recently
     * updated. When a backup schedule is first created, this is the same as
     * create_time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * At what relative time in the future, compared to its creation time,
     * the backup should be deleted, e.g. keep backups for 7 days.
     * The maximum supported retention period is 14 weeks.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration retention = 6;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getRetention()
    {
        return $this->retention;
    }

    public function hasRetention()
    {
        return isset($this->retention);
    }

    public function clearRetention()
    {
        unset($this->retention);
    }

    /**
     * At what relative time in the future, compared to its creation time,
     * the backup should be deleted, e.g. keep backups for 7 days.
     * The maximum supported retention period is 14 weeks.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration retention = 6;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setRetention($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->retention = $var;

        return $this;
    }

    /**
     * For a schedule that runs daily.
     *
     * Generated from protobuf field <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
     * @return \Google\Cloud\Firestore\Admin\V1\DailyRecurrence|null
     */
    public function getDailyRecurrence()
    {
        return $this->readOneof(7);
    }

    public function hasDailyRecurrence()
    {
        return $this->hasOneof(7);
    }

    /**
     * For a schedule that runs daily.
     *
     * Generated from protobuf field <code>.google.firestore.admin.v1.DailyRecurrence daily_recurrence = 7;</code>
     * @param \Google\Cloud\Firestore\Admin\V1\DailyRecurrence $var
     * @return $this
     */
    public function setDailyRecurrence($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Firestore\Admin\V1\DailyRecurrence::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * For a schedule that runs weekly on a specific day.
     *
     * Generated from protobuf field <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
     * @return \Google\Cloud\Firestore\Admin\V1\WeeklyRecurrence|null
     */
    public function getWeeklyRecurrence()
    {
        return $this->readOneof(8);
    }

    public function hasWeeklyRecurrence()
    {
        return $this->hasOneof(8);
    }

    /**
     * For a schedule that runs weekly on a specific day.
     *
     * Generated from protobuf field <code>.google.firestore.admin.v1.WeeklyRecurrence weekly_recurrence = 8;</code>
     * @param \Google\Cloud\Firestore\Admin\V1\WeeklyRecurrence $var
     * @return $this
     */
    public function setWeeklyRecurrence($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Firestore\Admin\V1\WeeklyRecurrence::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getRecurrence()
    {
        return $this->whichOneof("recurrence");
    }

}

